<?php
// Enable CORS to allow frontend requests
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

include 'db.php';

// Function to generate a random OTP
function generateOTP($length = 6) {
    $otp = '';
    $characters = '0123456789';
    for ($i = 0; $i < $length; $i++) {
        $otp .= $characters[random_int(0, strlen($characters) - 1)];
    }
    return $otp;
}

// Response function
function sendResponse($success, $message = '', $data = null) {
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'data' => $data
    ]);
    exit;
}

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method');
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate required fields
if (!isset($input['phone_number']) || 
    !preg_match('/^\d{10}$/', $input['phone_number']) ||
    !isset($input['reference_name']) ||
    !isset($input['application_name'])) {
    sendResponse(false, 'Missing or invalid required fields');
}

$phoneNumber = $input['phone_number'];
$referenceName = htmlspecialchars($input['reference_name']);
$applicationName = htmlspecialchars($input['application_name']);

try {
    // Generate OTP
    $otp = generateOTP();
    
    // Set timezone explicitly
    $timezone = new DateTimeZone('Asia/Kolkata');
    $dateTime = new DateTime('now', $timezone);
    
    // Add 5 minutes for expiration
    $dateTime->add(new DateInterval('PT5M'));
    $expiryTime = $dateTime->format('Y-m-d H:i:s');

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO otp_attempts (phone_number, otp, created_at, expires_at) 
                           VALUES (?, ?, NOW(), ?) 
                           ON DUPLICATE KEY UPDATE otp = ?, created_at = NOW(), expires_at = ?");
    $stmt->bind_param("sssss", $phoneNumber, $otp, $expiryTime, $otp, $expiryTime);
    
    if (!$stmt->execute()) {
        throw new Exception('Failed to save OTP: ' . $stmt->error);
    }

    // Updated SMS message with reference and application names
    $smsText = "Dear {$referenceName},\n" .
           "Thank you for agreeing to be a guarantor for the loan application of {$applicationName}. " .
           "To confirm your mobile number for the process, please enter the OTP: {$otp}.\n" .
           "If you did not authorize this request, please contact us immediately.\n\n" .
           "Thank you,\n" .
           "Shubh Labh Nagri Patsanstha Hinganghat";

    
    // Prepare SMS API URL
    $username = 'shubhlabh.trans';
    $password = '8KIvS';
    $from = 'SHBLBH';
    $dltContentId = '1707173141232095131';

    // Construct the API URL
    $apiUrl = "https://pgapi.vispl.in/fe/api/v1/send?" . http_build_query([
        'username' => $username,
        'password' => $password,
        'unicode' => 'false',
        'from' => $from,
        'to' => '91' . $phoneNumber,
        'dltContentId' => $dltContentId,
        'text' => $smsText
    ]);

    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    // Execute the request
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception('cURL Error: ' . curl_error($ch));
    }

    curl_close($ch);

    // Decode the response
    $responseData = json_decode($response, true);
    
    if ($responseData && 
        isset($responseData['state']) && 
        $responseData['state'] === 'SUBMIT_ACCEPTED' && 
        $responseData['statusCode'] == 200
    ) {
        sendResponse(true, 'OTP sent successfully', [
            'transactionId' => $responseData['transactionId']
        ]);
    } else {
        throw new Exception('SMS sending failed: ' . print_r($responseData, true));
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();

} catch (Exception $e) {
    sendResponse(false, $e->getMessage());
}