<?php
// Enable CORS to allow frontend requests
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

include 'db.php';
// Function to generate a random OTP
function generateOTP($length = 6) {
    $otp = '';
    $characters = '0123456789';
    for ($i = 0; $i < $length; $i++) {
        $otp .= $characters[random_int(0, strlen($characters) - 1)];
    }
    return $otp;
}

// Response function
function sendResponse($success, $message = '', $data = null) {
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'data' => $data
    ]);
    exit;
}

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method');
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate phone number
if (!isset($input['phone_number']) || 
    !preg_match('/^\d{10}$/', $input['phone_number'])) {
    sendResponse(false, 'Invalid phone number');
}

$phoneNumber = $input['phone_number'];

try {
    // Generate OTP
    $otp = generateOTP();
    
    // Set timezone explicitly (e.g., 'Asia/Kolkata' for India)
    $timezone = new DateTimeZone('Asia/Kolkata');  // Change this to your desired timezone
    $dateTime = new DateTime('now', $timezone);  // Set the current time with the specified timezone

    // Add 5 minutes to the current time for expiration
    $dateTime->add(new DateInterval('PT5M'));  
    $expiryTime = $dateTime->format('Y-m-d H:i:s');  // Format expiry time

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO otp_attempts (phone_number, otp, created_at, expires_at) 
                            VALUES (?, ?, NOW(), ?) 
                            ON DUPLICATE KEY UPDATE otp = ?, created_at = NOW(), expires_at = ?");
    $stmt->bind_param("sssss", $phoneNumber, $otp, $expiryTime, $otp, $expiryTime);
    
    // Execute the statement
    if (!$stmt->execute()) {
        throw new Exception('Failed to save OTP: ' . $stmt->error);
    }

    // Prepare SMS message
    $smsText = str_replace('${var1}', $otp, 
        "Dear Applicant,\nYour OTP for the loan application is {$otp}. Please use this code to complete your process.\nIf you did not request this, please contact us immediately.\nThank you,\nShubh Labh Nagri Patsanstha Hinganghat");
    
     // Prepare SMS API URL
     $username = 'shubhlabh.trans';
     $password = '8KIvS';
     $from = 'SHBLBH';
     $dltContentId = '1707173140800625493';

      // Construct the API URL
    $apiUrl = "https://pgapi.vispl.in/fe/api/v1/send?" . http_build_query([
        'username' => $username,
        'password' => $password,
        'unicode' => 'false',
        'from' => $from,
        'to' => '91' . $phoneNumber, // Ensure international format
        'dltContentId' => $dltContentId,
        'text' => $smsText
    ]);

    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Consider using true in production

      // Execute the request
      $response = curl_exec($ch);

       // Check for cURL errors
    if (curl_errno($ch)) {
        throw new Exception('cURL Error: ' . curl_error($ch));
    }

        // Close cURL session
        curl_close($ch);

       // Decode the response (adjust based on the actual API response format)
    $responseData = json_decode($response, true);
    
                // Check API response
            if ($responseData && 
            isset($responseData['state']) && 
            $responseData['state'] === 'SUBMIT_ACCEPTED' && 
            $responseData['statusCode'] == 200
            ) {
            // SMS sent successfully
            sendResponse(true, 'OTP sent successfully', [
                'transactionId' => $responseData['transactionId']
            ]);
            } else {
            // Handle potential errors
            throw new Exception('SMS sending failed: ' . print_r($responseData, true));
            }

    // Close statement and connection
    $stmt->close();
    $conn->close();

    // Send successful response
    sendResponse(true, 'OTP sent successfully');

} catch (Exception $e) {
    // Handle any errors
    sendResponse(false, $e->getMessage());
}
